#include <iconv.h>
#include "xmalloc.h"

#define SIZEOF_WCHAR	4

size_t
convbuf (const char *to, const char *from, const char *inbuf, size_t inlen, char **outbufp)
{
	char *inp, *outp;
	size_t outlen, outleft, ir;
	iconv_t d;

	d = iconv_open(to, from);
	if (!d) {
		*outbufp = 0;
		return 0;
	}
	inp = (char *)inbuf;
	outlen = inlen*SIZEOF_WCHAR;
	outp = xmalloc(outlen+1);
	outleft = outlen;
	for (;;) {
		ir = iconv(d, &inp, &inlen, &outp, &outleft);
		if (ir == (size_t)-1) {
			*outbufp = 0;
			return 0;
		}
		if (inlen == 0)
			break;
	}
	outlen -= outleft;
	outp = outp - outlen;
	*outbufp = outp;
	iconv_close(d);
	outp[outlen] = 0;

	return outlen;
}
